"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatelessHeaderPromo = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _promo = require("./promo");
var _cta_link = require("./cta_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/header/stateless_promo.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatelessHeaderPromo = () => {
  return /*#__PURE__*/_react.default.createElement(_promo.HeaderPromo, {
    title: _i18n.i18n.translate('xpack.searchHomepage.header.statelessPromo.9.title', {
      defaultMessage: 'Excluding vectors from source'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.header.statelessPromo.9.description', {
      defaultMessage: 'Elasticsearch now excludes vectors from source by default, saving space and improving performance while keeping vectors accessible when needed.'
    }),
    cta: /*#__PURE__*/_react.default.createElement(_cta_link.HeaderCTALink, {
      "data-telemetry-id": "9-exclude-vectors",
      href: "https://www.elastic.co/search-labs/blog/elasticsearch-exclude-vectors-from-source",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchHomepage.statelessPromo.9.content', {
      defaultMessage: 'View on Elasticsearch Labs'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  });
};
exports.StatelessHeaderPromo = StatelessHeaderPromo;