"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VectorSearch = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _ai_search_workflow = require("./ai_search_workflow");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/ai_search_capabilities/vector_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const VectorSearch = () => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const vectorSearchText = {
    image: `${assetBasePath}/vector_search.svg`,
    imageAlt: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.imageAlt', {
      defaultMessage: 'Vector search'
    }),
    heading: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.title', {
      defaultMessage: 'Store and search your vector embeddings'
    }),
    subheading: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.description', {
      defaultMessage: 'Use Elasticsearch as a datastore for vector embeddings and enable lightning-fast searches and insights.'
    }),
    featureBullets: [_i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.firstLine', {
      defaultMessage: 'A single solution to generate, store and search your vector embeddings.'
    }), _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.secondLine', {
      defaultMessage: 'Utilize the dense_vector field type for approximate kNN searches.'
    }), _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.thirdLine', {
      defaultMessage: 'Choose from several memory quantization strategies to reduce bloat.'
    })],
    buttonLabel: _i18n.i18n.translate('xpack.searchHomepage.aiSearchCapabilities.vectorSearch.createVectorIndex', {
      defaultMessage: 'Create a vector optimized index'
    }),
    dataTestSubj: 'createVectorIndexButton',
    workflow: 'vector'
  };
  return /*#__PURE__*/_react.default.createElement(_ai_search_workflow.AISearchWorkflow, {
    capability: vectorSearchText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  });
};
exports.VectorSearch = VectorSearch;