"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sha256 = sha256;
var _crypto = require("crypto");
var _fs = require("fs");
var _promises = require("stream/promises");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function sha256(path) {
  const hash = (0, _crypto.createHash)('sha256');
  const stream = (0, _fs.createReadStream)(path);
  stream.on('data', chunk => hash.update(chunk));
  await (0, _promises.finished)(stream);
  return hash.digest('hex');
}