"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchServerPlugin = void 0;
var _saved_objects = require("./saved_objects");
var _common = require("../common");
var _content_management = require("./content_management");
var _expressions = require("../common/expressions");
var _kibana_context = require("./expressions/kibana_context");
var _get_saved_searches = require("../common/service/get_saved_searches");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Saved search plugin server Setup contract
 */

class SavedSearchServerPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
  }
  setup(core, {
    data,
    contentManagement,
    expressions
  }) {
    contentManagement.register({
      id: _common.SavedSearchType,
      storage: new _content_management.SavedSearchStorage({
        throwOnResultValidationError: this.initializerContext.env.mode.dev,
        logger: this.initializerContext.logger.get('storage')
      }),
      version: {
        latest: _common.LATEST_VERSION
      }
    });
    const searchSource = data.search.searchSource;
    const getSearchSourceMigrations = searchSource.getAllMigrations.bind(searchSource);
    core.savedObjects.registerType((0, _saved_objects.getSavedSearchObjectType)(getSearchSourceMigrations));
    expressions.registerType(_expressions.kibanaContext);
    expressions.registerFunction((0, _kibana_context.getKibanaContext)(core.getStartServices));
    return {};
  }
  start(core) {
    return {
      getSavedSearch: _get_saved_searches.getSavedSearch
    };
  }
  stop() {}
}
exports.SavedSearchServerPlugin = SavedSearchServerPlugin;