"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagAssignmentService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TagAssignmentService {
  constructor({
    http
  }) {
    (0, _defineProperty2.default)(this, "http", void 0);
    this.http = http;
  }
  async findAssignableObjects({
    search,
    types,
    maxResults
  }) {
    const {
      objects
    } = await this.http.get('/internal/saved_objects_tagging/assignments/_find_assignable_objects', {
      query: {
        search,
        types,
        max_results: maxResults
      }
    });
    return objects;
  }
  async updateTagAssignments({
    tags,
    assign,
    unassign
  }) {
    await this.http.post('/api/saved_objects_tagging/assignments/update_by_tags', {
      body: JSON.stringify({
        tags,
        assign,
        unassign
      })
    });
  }
  async getAssignableTypes() {
    const {
      types
    } = await this.http.get('/internal/saved_objects_tagging/assignments/_assignable_types');
    return types;
  }
}
exports.TagAssignmentService = TagAssignmentService;