"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssignFlyoutSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/components/assign_flyout/components/search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AssignFlyoutSearchBar = ({
  onChange,
  types,
  isLoading
}) => {
  const filters = (0, _react.useMemo)(() => {
    return [{
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.i18n.translate('xpack.savedObjectsTagging.assignFlyout.typeFilterName', {
        defaultMessage: 'Type'
      }),
      multiSelect: 'or',
      options: types.map(type => ({
        value: type,
        name: type
      }))
    }];
  }, [types]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: {
      'data-test-subj': 'assignFlyoutSearchBar',
      placeholder: _i18n.i18n.translate('xpack.savedObjectsTagging.assignFlyout.searchPlaceholder', {
        defaultMessage: 'Search by saved object name'
      }),
      isLoading
    },
    onChange: onChange,
    filters: filters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.AssignFlyoutSearchBar = AssignFlyoutSearchBar;