"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRelationships = getRelationships;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getRelationships(http, type, id, savedObjectTypes, size) {
  const url = `/api/kibana/management/saved_objects/relationships/${encodeURIComponent(type)}/${encodeURIComponent(id)}`;
  try {
    return await http.get(url, {
      query: {
        savedObjectTypes,
        ...(size ? {
          size
        } : {})
      }
    });
  } catch (respError) {
    const respBody = (0, _lodash.get)(respError, 'data', {});
    const err = new Error(respBody.message || respBody.error || `${respError.status} Response`);
    err.statusCode = respBody.statusCode || respError.status;
    err.body = respBody;
    throw err;
  }
}