"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.majorMinor = exports.latestVersion = void 0;
var _semver = _interopRequireDefault(require("semver"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const latestVersion = versions => {
  let latest = versions[0];
  for (let i = 1; i < versions.length; i++) {
    const current = versions[i];
    if (_semver.default.gt(_semver.default.coerce(current), _semver.default.coerce(latest))) {
      latest = current;
    }
  }
  return latest;
};
exports.latestVersion = latestVersion;
const majorMinor = version => {
  const parsed = _semver.default.coerce(version);
  if (!parsed) {
    throw new Error(`Not a valid semver version: [${version}]`);
  }
  return `${parsed.major}.${parsed.minor}`;
};
exports.majorMinor = majorMinor;