"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInstallationRoutes = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerInstallationRoutes = ({
  router,
  getServices
}) => {
  router.post({
    path: _common.INSTALL_API_PATH,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: false,
    options: {
      access: 'internal',
      timeout: {
        idleSocket: 3 * 60 * 1000
      } // install can take time.
    }
  }, async (ctx, req, res) => {
    const core = await ctx.core;
    const esClient = core.elasticsearch.client.asCurrentUser;
    const {
      sampleDataManager
    } = getServices();
    const {
      client: soClient,
      getImporter
    } = core.savedObjects;
    try {
      const installResponse = await sampleDataManager.installSampleData({
        sampleType: _common.DatasetSampleType.elasticsearch,
        esClient,
        soClient,
        soImporter: getImporter(soClient)
      });
      return res.ok({
        body: {
          status: 'installed',
          ...installResponse
        }
      });
    } catch (e) {
      var _e$meta, _e$meta$body, _e$meta$body$error, _e$meta2, _e$meta3;
      switch (e === null || e === void 0 ? void 0 : (_e$meta = e.meta) === null || _e$meta === void 0 ? void 0 : (_e$meta$body = _e$meta.body) === null || _e$meta$body === void 0 ? void 0 : (_e$meta$body$error = _e$meta$body.error) === null || _e$meta$body$error === void 0 ? void 0 : _e$meta$body$error.type) {
        case 'resource_already_exists_exception':
          return res.conflict({
            body: {
              message: e.message
            }
          });
      }
      return res.customError({
        statusCode: e !== null && e !== void 0 && e.meta && (_e$meta2 = e.meta) !== null && _e$meta2 !== void 0 && _e$meta2.statusCode ? (_e$meta3 = e.meta) === null || _e$meta3 === void 0 ? void 0 : _e$meta3.statusCode : 500,
        body: {
          message: _i18n.i18n.translate('xpack.sampleDataIngest.server.installSample.errorMessage', {
            defaultMessage: 'Failed to install sample data due to an exception.'
          })
        }
      });
    }
  });
  router.get({
    path: _common.STATUS_API_PATH,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the scoped ES client'
      }
    },
    validate: false,
    options: {
      access: 'internal'
    }
  }, async (ctx, req, res) => {
    const core = await ctx.core;
    const esClient = core.elasticsearch.client.asCurrentUser;
    const soClient = core.savedObjects.client;
    const {
      sampleDataManager
    } = getServices();
    try {
      const statusData = await sampleDataManager.getSampleDataStatus({
        sampleType: _common.DatasetSampleType.elasticsearch,
        esClient,
        soClient
      });
      return res.ok({
        body: statusData
      });
    } catch (e) {
      var _e$meta4, _e$meta5;
      return res.customError({
        statusCode: e !== null && e !== void 0 && e.meta && (_e$meta4 = e.meta) !== null && _e$meta4 !== void 0 && _e$meta4.statusCode ? (_e$meta5 = e.meta) === null || _e$meta5 === void 0 ? void 0 : _e$meta5.statusCode : 500,
        body: {
          message: _i18n.i18n.translate('xpack.sampleDataIngest.server.getStatus.errorMessage', {
            defaultMessage: 'Failed to get status due to an exception.'
          })
        }
      });
    }
  });
};
exports.registerInstallationRoutes = registerInstallationRoutes;