"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detailPanel = detailPanel;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isOpen: false,
  panelType: undefined,
  jobId: undefined
};
function detailPanel(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.OPEN_DETAIL_PANEL:
      const {
        panelType,
        jobId
      } = payload;
      return {
        panelType: panelType || state.panelType,
        jobId,
        isOpen: true
      };
    case _action_types.CLOSE_DETAIL_PANEL:
      return {
        panelType: undefined,
        jobId: undefined,
        isOpen: false
      };
    default:
      return state;
  }
}