"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduledReport = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _reportingCommon = require("@kbn/reporting-common");
var _report = require("./report");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ScheduledReport extends _report.Report {
  /*
   * Create a report from a scheduled_report saved object
   */
  constructor(opts) {
    const {
      kibanaId,
      kibanaName,
      runAt,
      scheduledReport,
      spaceId,
      queueTimeout
    } = opts;
    const now = _moment.default.utc();
    const startTime = now.toISOString();
    const expirationTime = now.add(queueTimeout).toISOString();
    let payload;
    try {
      payload = JSON.parse(scheduledReport.attributes.payload);
    } catch (e) {
      throw new Error(`Unable to parse payload from scheduled_report saved object: ${e}`);
    }
    payload.forceNow = runAt.toISOString();
    payload.title = `${scheduledReport.attributes.title} [${runAt.toISOString()}]`;
    if (!scheduledReport.id) {
      throw new Error(`Invalid scheduled_report saved object - no id`);
    }
    super({
      migration_version: scheduledReport.attributes.migrationVersion,
      jobtype: scheduledReport.attributes.jobType,
      created_at: runAt.toISOString(),
      created_by: scheduledReport.attributes.createdBy,
      payload,
      meta: scheduledReport.attributes.meta,
      status: _reportingCommon.JOB_STATUS.PROCESSING,
      attempts: 1,
      process_expiration: expirationTime,
      kibana_id: kibanaId,
      kibana_name: kibanaName,
      max_attempts: 1,
      started_at: startTime,
      timeout: queueTimeout,
      scheduled_report_id: scheduledReport.id,
      space_id: spaceId
    }, {
      queue_time_ms: [now.diff(_moment.default.utc(runAt), 'milliseconds')]
    });
  }
}
exports.ScheduledReport = ScheduledReport;