"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PdfV1ExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _rxjs = require("rxjs");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesPdfCommon = require("@kbn/reporting-export-types-pdf-common");
var _reportingServer = require("@kbn/reporting-server");
var _get_custom_logo = require("./get_custom_logo");
var _get_full_urls = require("./get_full_urls");
var _pdf_tracker = require("./pdf_tracker");
var _validate_urls = require("./validate_urls");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * @deprecated
 */
class PdfV1ExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", 'printablePdf');
    (0, _defineProperty2.default)(this, "name", 'PDF');
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesPdfCommon.PDF_JOB_TYPE);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'pdf');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    (0, _defineProperty2.default)(this, "createJob", async ({
      relativeUrls,
      ...jobParams
    }) => {
      (0, _validate_urls.validateUrls)(relativeUrls);

      // return the payload
      return {
        ...jobParams,
        isDeprecated: true,
        forceNow: new Date().toISOString(),
        objects: relativeUrls.map(u => ({
          relativeUrl: u
        }))
      };
    });
    (0, _defineProperty2.default)(this, "runTask", async ({
      jobId,
      payload: job,
      request,
      taskInstanceFields,
      cancellationToken,
      stream
    }) => {
      const logger = this.logger.get('execute-job');
      const apmTrans = _elasticApmNode.default.startTransaction('execute-job-pdf', _reportingServer.REPORTING_TRANSACTION_TYPE);
      const apmGetAssets = apmTrans.startSpan('get-assets', 'setup');
      let apmGeneratePdf;
      const process$ = (0, _rxjs.of)(1).pipe((0, _rxjs.mergeMap)(async () => {
        const uiSettingsClient = await this.getUiSettingsClient(request);
        return (0, _get_custom_logo.getCustomLogo)(uiSettingsClient);
      }), (0, _rxjs.mergeMap)(logo => {
        const urls = (0, _get_full_urls.getFullUrls)(this.getServerInfo(), this.config, job);
        const {
          browserTimezone,
          layout,
          title
        } = job;
        apmGetAssets === null || apmGetAssets === void 0 ? void 0 : apmGetAssets.end();
        apmGeneratePdf = apmTrans.startSpan('generate-pdf-pipeline', 'execute');
        const tracker = (0, _pdf_tracker.getTracker)();
        tracker.startScreenshots();
        return this.startDeps.screenshotting.getScreenshots({
          format: 'pdf',
          title,
          logo,
          urls,
          request,
          browserTimezone,
          layout,
          taskInstanceFields,
          logger
        }).pipe((0, _rxjs.tap)(({
          metrics
        }) => {
          if (metrics.cpu) {
            tracker.setCpuUsage(metrics.cpu);
          }
          if (metrics.memory) {
            tracker.setMemoryUsage(metrics.memory);
          }
        }), (0, _rxjs.mergeMap)(async ({
          data: buffer,
          errors,
          metrics,
          renderErrors
        }) => {
          tracker.endScreenshots();
          const warnings = [];
          if (errors) {
            warnings.push(...errors.map(error => error.message));
          }
          if (renderErrors) {
            warnings.push(...renderErrors);
          }
          tracker.end();
          return {
            buffer,
            metrics,
            warnings
          };
        }));
      }), (0, _rxjs.tap)(({
        buffer
      }) => {
        var _apmGeneratePdf;
        (_apmGeneratePdf = apmGeneratePdf) === null || _apmGeneratePdf === void 0 ? void 0 : _apmGeneratePdf.end();
        if (buffer) {
          stream.write(buffer);
        }
      }), (0, _rxjs.map)(({
        metrics,
        warnings
      }) => ({
        content_type: 'application/pdf',
        metrics: {
          pdf: metrics
        },
        warnings
      })), (0, _rxjs.catchError)(err => {
        logger.debug(err, {
          tags: [jobId]
        });
        return (0, _rxjs.throwError)(err);
      }));
      const stop$ = (0, _rxjs.fromEventPattern)(cancellationToken.on);
      apmTrans.end();
      return (0, _rxjs.lastValueFrom)(process$.pipe((0, _rxjs.takeUntil)(stop$)));
    });
    this.logger = this.logger.get('png-export-v1');
  }
}
exports.PdfV1ExportType = PdfV1ExportType;