"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CsvV2ExportType = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _generateCsv = require("@kbn/generate-csv");
var _reportingCommon = require("@kbn/reporting-common");
var _reportingExportTypesCsvCommon = require("@kbn/reporting-export-types-csv-common");
var _reportingServer = require("@kbn/reporting-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class CsvV2ExportType extends _reportingServer.ExportType {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _reportingExportTypesCsvCommon.CSV_REPORT_TYPE_V2);
    (0, _defineProperty2.default)(this, "name", _reportingExportTypesCsvCommon.CSV_REPORT_TYPE_V2);
    (0, _defineProperty2.default)(this, "jobType", _reportingExportTypesCsvCommon.CSV_REPORT_TYPE_V2);
    (0, _defineProperty2.default)(this, "jobContentEncoding", 'base64');
    (0, _defineProperty2.default)(this, "jobContentExtension", 'csv');
    (0, _defineProperty2.default)(this, "validLicenses", [_reportingCommon.LICENSE_TYPE_TRIAL, _reportingCommon.LICENSE_TYPE_BASIC, _reportingCommon.LICENSE_TYPE_CLOUD_STANDARD, _reportingCommon.LICENSE_TYPE_GOLD, _reportingCommon.LICENSE_TYPE_PLATINUM, _reportingCommon.LICENSE_TYPE_ENTERPRISE]);
    (0, _defineProperty2.default)(this, "createJob", async (jobParams, _context, req) => {
      // 1. Validation of locatorParams
      const {
        locatorParams
      } = jobParams;
      const {
        id,
        params
      } = locatorParams[0];
      if (!locatorParams || !Array.isArray(locatorParams) || locatorParams.length !== 1 || id !== 'DISCOVER_APP_LOCATOR' || !params) {
        throw _boom.default.badRequest('Invalid Job params: must contain a single Discover App locator');
      }

      // use Discover contract to get the title of the report from job params
      const {
        discover: discoverPluginStart
      } = this.startDeps;
      const locatorClient = await discoverPluginStart.locator.asScopedClient(req);
      const title = jobParams.title || (await locatorClient.titleFromLocator(params));
      const objectType = 'search';
      const pagingStrategy = this.config.csv.scroll.strategy;
      return {
        ...jobParams,
        title,
        objectType,
        pagingStrategy
      };
    });
    (0, _defineProperty2.default)(this, "runTask", async ({
      jobId,
      payload: job,
      request,
      taskInstanceFields,
      cancellationToken,
      stream
    }) => {
      const logger = this.logger.get(`execute:${jobId}`);
      const config = this.config;
      const {
        csv: csvConfig
      } = config;
      const uiSettings = await this.getUiSettingsClient(request, logger);
      const fieldFormatsRegistry = await (0, _reportingServer.getFieldFormats)().fieldFormatServiceFactory(uiSettings);
      const {
        data: dataPluginStart,
        discover: discoverPluginStart
      } = this.startDeps;
      const data = dataPluginStart.search.asScoped(request);
      const {
        locatorParams
      } = job;
      const {
        params
      } = locatorParams[0];

      // use Discover contract to convert the job params into inputs for CsvGenerator
      const locatorClient = await discoverPluginStart.locator.asScopedClient(request);
      const query = await locatorClient.queryFromLocator(params);
      if (query && 'esql' in query) {
        // TODO: use columnsFromLocator
        // currently locatorClient.columnsFromLocator can only extract columns from the saved search,
        // but for the es|ql we simply want to get currently visible columns from params.columns.
        // we didn't want to add this change inside locatorClient.columnsFromLocator, as it would change the behaviour of csv_v2 for non-ES|QL export,
        // this should be addressed here https://github.com/elastic/kibana/issues/151190
        // const columns = await locatorClient.columnsFromLocator(params);
        const columns = params.columns;
        const filters = await locatorClient.filtersFromLocator(params);
        const es = this.startDeps.esClient.asScoped(request);
        const clients = {
          uiSettings,
          data,
          es
        };
        const csv = new _generateCsv.CsvESQLGenerator({
          columns,
          query,
          filters,
          ...job
        }, csvConfig, taskInstanceFields, clients, cancellationToken, logger, stream, jobId);
        return await csv.generateData();
      }
      const columns = await locatorClient.columnsFromLocator(params);
      const searchSource = await locatorClient.searchSourceFromLocator(params);
      const es = this.startDeps.esClient.asScoped(request);
      const searchSourceStart = await dataPluginStart.search.searchSource.asScoped(request);
      const clients = {
        uiSettings,
        data,
        es
      };
      const dependencies = {
        searchSourceStart,
        fieldFormatsRegistry
      };
      const csv = new _generateCsv.CsvGenerator({
        columns,
        searchSource: searchSource.getSerializedFields(true),
        ...job
      }, csvConfig, taskInstanceFields, clients, dependencies, cancellationToken, logger, stream, jobId);
      return await csv.generateData();
    });
    this.logger = this.logger.get('csv-export-v2');
  }
}
exports.CsvV2ExportType = CsvV2ExportType;