"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detailPanel = void 0;
var _services = require("../../services");
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const detailPanel = () => next => action => {
  const {
    type
  } = action;
  switch (type) {
    case _action_types.CLOSE_DETAIL_PANEL:
      if (!(0, _services.getUserHasLeftApp)()) {
        const {
          history
        } = (0, _services.getRouter)();

        // Persist state to query params by removing deep link.
        history.replace({
          search: ''
        });
      }
      break;
  }
  return next(action);
};
exports.detailPanel = detailPanel;