"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterSetupTrust = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/components/remote_cluster_config_steps/remote_cluster_setup_trust/remote_cluster_setup_trust.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MIN_ALLOWED_VERSION_API_KEYS_METHOD = '8.10';
const CARD_MAX_WIDTH = 400;
const i18nTexts = {
  apiKeyTitle: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithApiKeys.title', {
    defaultMessage: 'API keys'
  }),
  apiKeyDescription: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithApiKeys.description', {
    defaultMessage: 'Fine-grained access to remote indices. You need an API key provided by the remote cluster administrator.'
  }),
  certTitle: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithCert.title', {
    defaultMessage: 'Certificates'
  }),
  certDescription: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithCert.description', {
    defaultMessage: 'Full access to the remote cluster. You need TLS certificates from the remote cluster.'
  })
};
const RemoteClusterSetupTrust = ({
  next,
  currentSecurityModel,
  onSecurityChange
}) => {
  const {
    canUseAPIKeyTrustModel
  } = (0, _react.useContext)(_app_context.AppContext);
  const [securityModel, setSecurityModel] = (0, _react.useState)(currentSecurityModel);
  (0, _react.useEffect)(() => {
    onSecurityChange(securityModel);
  }, [onSecurityChange, securityModel]);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiText, {
    size: "m",
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.title",
    defaultMessage: "Set up an authentication mechanism to connect to the remote cluster.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_shared_imports.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexGroup, {
    gutterSize: "l",
    wrap: true,
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, canUseAPIKeyTrustModel && /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    style: {
      maxWidth: CARD_MAX_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiCard, {
    paddingSize: "l",
    "data-test-subj": "setupTrustApiMode",
    title: i18nTexts.apiKeyTitle,
    description: i18nTexts.apiKeyDescription,
    footer: /*#__PURE__*/_react.default.createElement(_shared_imports.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.clusterWizard.trustStep.apiKeyNote",
      defaultMessage: "Both clusters must be on version {minAllowedVersion} or above.",
      values: {
        minAllowedVersion: MIN_ALLOWED_VERSION_API_KEYS_METHOD
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 21
      }
    }))),
    selectable: {
      onClick: () => {
        setSecurityModel(_constants.SECURITY_MODEL.API);
      },
      isSelected: securityModel === _constants.SECURITY_MODEL.API
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    style: {
      maxWidth: CARD_MAX_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiCard, {
    paddingSize: "l",
    "data-test-subj": "setupTrustCertMode",
    title: i18nTexts.certTitle,
    description: i18nTexts.certDescription,
    selectable: {
      onClick: () => {
        setSecurityModel(_constants.SECURITY_MODEL.CERTIFICATE);
      },
      isSelected: securityModel === _constants.SECURITY_MODEL.CERTIFICATE
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_shared_imports.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.ActionButtons, {
    showRequest: false,
    disabled: !securityModel,
    handleNext: () => {
      next(securityModel);
    },
    confirmFormText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.nextButtonLabel",
      defaultMessage: "Next",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }),
    nextButtonTestSubj: 'remoteClusterTrustNextButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
};
exports.RemoteClusterSetupTrust = RemoteClusterSetupTrust;