"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/es-ui-shared-plugin/public");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ReindexService {
  constructor(client) {
    (0, _defineProperty2.default)(this, "client", void 0);
    this.client = client;
  }
  async getReindexStatus(indexName) {
    return (0, _public.sendRequest)(this.client, {
      method: 'get',
      path: `${_common.REINDEX_SERVICE_BASE_PATH}/${indexName}`
    });
  }
  async startReindex(reindexArgs) {
    return (0, _public.sendRequest)(this.client, {
      method: 'post',
      path: _common.REINDEX_SERVICE_BASE_PATH,
      body: reindexArgs
    });
  }
  async cancelReindex(indexName) {
    return (0, _public.sendRequest)(this.client, {
      method: 'post',
      path: `${_common.REINDEX_SERVICE_BASE_PATH}/${indexName}/cancel`
    });
  }
}

//
exports.ReindexService = ReindexService;