"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphView = FlameGraphView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _ebtTools = require("@kbn/ebt-tools");
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _flamegraph = require("../../../components/flamegraph");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_route_path = require("../../../hooks/use_profiling_route_path");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _use_async = require("../../../hooks/use_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/views/flamegraphs/flamegraph/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FlameGraphView() {
  var _state$data2;
  const {
    query,
    query: {
      rangeFrom,
      rangeTo,
      kuery,
      searchText
    }
  } = (0, _use_profiling_params.useProfilingParams)('/flamegraphs/flamegraph');
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchElasticFlamechart
    },
    start: {
      core
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const showErrorFrames = core.uiSettings.get(_common.profilingShowErrorFrames);
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchElasticFlamechart({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      kuery,
      showErrorFrames
    });
  }, [fetchElasticFlamechart, timeRange.start, timeRange.end, kuery, showErrorFrames]);
  const {
    data
  } = state;
  const routePath = (0, _use_profiling_route_path.useProfilingRoutePath)();
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function handleSearchTextChange(newSearchText) {
    // @ts-expect-error Code gets too complicated to satisfy TS constraints
    profilingRouter.push(routePath, {
      query: {
        ...query,
        searchText: newSearchText
      }
    });
  }
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    if (state.status === _use_async.AsyncStatus.Settled) {
      var _state$data$TotalSamp, _state$data;
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'totalSamples',
          value1: (_state$data$TotalSamp = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.TotalSamples) !== null && _state$data$TotalSamp !== void 0 ? _state$data$TotalSamp : 0
        }
      });
    }
  }, [onPageReady, state.status, (_state$data2 = state.data) === null || _state$data2 === void 0 ? void 0 : _state$data2.TotalSamples, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    style: {
      height: '100%'
    },
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_flamegraph.FlameGraph, {
    id: "flamechart",
    primaryFlamegraph: data,
    searchText: searchText,
    onChangeSearchText: handleSearchTextChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))));
}