"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asWeight = asWeight;
var _as_number = require("./as_number");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_POUND_TO_A_KILO = 0.45359237;
const ONE_KILO_TO_A_POUND = 2.20462;
function asWeight(value, unit) {
  const formattedValue = (0, _as_number.asNumber)(value);
  if (unit === 'lbs') {
    const kgs = (0, _as_number.asNumber)(Number(value * ONE_POUND_TO_A_KILO));
    return `${formattedValue} lbs / ${kgs} kg`;
  }
  const lbs = (0, _as_number.asNumber)(Number(value * ONE_KILO_TO_A_POUND));
  return `${lbs} lbs / ${formattedValue} kg`;
}