"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRangeAsync = void 0;
var _use_async = require("./use_async");
var _use_time_range_context = require("./use_time_range_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimeRangeAsync = (fn, dependencies) => {
  const {
    timeRangeId
  } = (0, _use_time_range_context.useTimeRangeContext)();

  // eslint-disable-next-line react-hooks/exhaustive-deps
  return (0, _use_async.useAsync)(fn, dependencies.concat(timeRangeId));
};
exports.useTimeRangeAsync = useTimeRangeAsync;