"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeRange = useTimeRange;
var _react = require("react");
var _get_next_time_range = require("../utils/get_next_time_range");
var _use_time_range_context = require("./use_time_range_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useTimeRange({
  rangeFrom,
  rangeTo,
  optional
}) {
  const timeRangeApi = (0, _use_time_range_context.useTimeRangeContext)();
  const {
    start,
    end
  } = (0, _react.useMemo)(() => {
    return (0, _get_next_time_range.getNextTimeRange)({
      state: {},
      rangeFrom,
      rangeTo
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [rangeFrom, rangeTo, timeRangeApi.timeRangeId]);
  if ((!start || !end) && !optional) {
    throw new Error('start and/or end were unexpectedly not set');
  }
  return {
    start,
    end,
    inSeconds: {
      start: start ? new Date(start).getTime() / 1000 : undefined,
      end: end ? new Date(end).getTime() / 1000 : undefined
    },
    timeRangeId: timeRangeApi.timeRangeId
  };
}