"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubChart = SubChart;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react2 = _interopRequireWildcard(require("react"));
var _topn = require("../../common/topn");
var _use_kibana_timezone_setting = require("../hooks/use_kibana_timezone_setting");
var _use_profiling_charts_theme = require("../hooks/use_profiling_charts_theme");
var _as_number = require("../utils/formatters/as_number");
var _as_percentage = require("../utils/formatters/as_percentage");
var _stack_frame_summary = require("./stack_frame_summary");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/subchart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NUM_DISPLAYED_FRAMES = 5;
function renderFrameItem(frame, parentIndex) {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: frame.FrameID,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, parentIndex), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_stack_frame_summary.StackFrameSummary, {
    frame: frame,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }))));
}
function SubChart({
  index,
  color,
  category,
  label,
  percentage,
  height,
  data,
  width,
  showAxes,
  metadata = [],
  onClick,
  style,
  showFrames,
  padTitle,
  sample
}) {
  const theme = (0, _eui.useEuiTheme)();
  const [accordionState, setAccordionState] = (0, _react2.useState)({});
  const timeZone = (0, _use_kibana_timezone_setting.useKibanaTimeZoneSetting)();
  const {
    chartsTheme,
    chartsBaseTheme
  } = (0, _use_profiling_charts_theme.useProfilingChartsTheme)();
  const compact = !!onClick;
  const parentsMetadata = metadata.filter(item => item.Inline === false);
  const displayedFrames = compact ? parentsMetadata.concat().reverse().slice(0, NUM_DISPLAYED_FRAMES) : parentsMetadata.concat().reverse();
  const childrenMetadata = (0, _react2.useMemo)(() => {
    const groupedMetadata = (0, _lodash.groupBy)(metadata, 'AddressOrLine');
    return Object.keys(groupedMetadata).reduce((acc, key) => {
      // Removes the first item as it will always be the parent item.
      const [_, ...children] = groupedMetadata[key];
      acc[key] = children;
      return acc;
    }, {});
  }, [metadata]);
  const hasMoreFrames = displayedFrames.length < metadata.length;
  let bottomElement;
  if (metadata.length > 0) {
    bottomElement = /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      style: {
        backgroundColor: theme.euiTheme.colors.lightestShade,
        padding: theme.euiTheme.size.m
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, displayedFrames.map((frame, frameIndex) => {
      const parentIndex = parentsMetadata.indexOf(frame) + 1;
      const children = childrenMetadata[frame.AddressOrLine].concat().reverse();
      const key = [frameIndex, frame.FrameID].join('|');
      const currentAccordionState = accordionState[key];
      return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
        key: key,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 17
        }
      }, children.length > 0 ? /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion
      // taking over the control of the EuiAccordion state
      // to avoid rendering the children items when the accordion is closed.
      // This renders the page way faster as it avoids unnecessary render of items that might never be visible
      , {
        forceState: currentAccordionState || 'closed',
        onToggle: isOpen => {
          setAccordionState(state => ({
            ...state,
            [key]: isOpen ? 'open' : 'closed'
          }));
        },
        css: (0, _react.css)`
                        display: flex;
                        flex-direction: column-reverse;

                        .css-bknxw4-euiButtonIcon-xs-empty-text-euiAccordion__arrow-left-isOpen {
                          transform: rotate(-90deg) !important;
                        }
                      `,
        id: `accordion_${frame.AddressOrLine}`,
        buttonContent: renderFrameItem(frame, parentIndex),
        paddingSize: "s",
        extraAction: /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
          content: _i18n.i18n.translate('xpack.profiling.traces.subChart.inlineDescription', {
            defaultMessage: 'This frame has {numberOfChildren} inline {numberOfChildren, plural, one {frame} other {frames}} inside, this allows for optimised processes.',
            values: {
              numberOfChildren: children.length
            }
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 170,
            columnNumber: 25
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
          color: "primary",
          tabIndex: 0,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 180,
            columnNumber: 27
          }
        }, `-> ${children.length}`)),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 147,
          columnNumber: 21
        }
      }, currentAccordionState === 'open' ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "s",
        style: {
          marginLeft: '12px'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 25
        }
      }, children.map((child, childIndex) => {
        return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
          key: [key, childIndex].join('|'),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 195,
            columnNumber: 31
          }
        }, renderFrameItem(child, `${parentIndex}.${children.length - childIndex} ->`));
      })) : null) : renderFrameItem(frame, parentIndex), frameIndex < displayedFrames.length - 1 || hasMoreFrames ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
        size: "full",
        margin: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 23
        }
      })) : null);
    })), hasMoreFrames && !!onClick && /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      "data-test-subj": "profilingSubChartShowMoreButton",
      onClick: onClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.profiling.stackTracesView.showMoreTracesButton', {
      defaultMessage: 'Show more'
    }))));
  } else if (category === _topn.OTHER_BUCKET_LABEL && showFrames) {
    bottomElement = /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      style: {
        padding: theme.euiTheme.size.m
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      alignItems: "center",
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.profiling.stackTracesView.otherTraces', {
      defaultMessage: '[This summarizes all traces that are too small to display]'
    }))));
  } else {
    bottomElement = /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 21
      }
    });
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    style: {
      ...style,
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      ...(padTitle ? {
        padding: theme.euiTheme.size.l,
        paddingBottom: theme.euiTheme.size.s
      } : {})
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center",
    style: {
      overflowWrap: 'anywhere'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: theme.euiTheme.colors.lightestShade,
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }, index))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      alignItems: 'flex-start'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  }, category === _topn.OTHER_BUCKET_LABEL || onClick === undefined ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 15
    }
  }, label) : /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    "data-test-subj": "profilingSubChartLink",
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 17
    }
  }, label))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 13
    }
  }, sample ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 19
    }
  }, (0, _as_percentage.asPercentage)(sample.Percentage / 100))) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: sample ? 'xs' : 's',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 17
    }
  }, sample ? _i18n.i18n.translate('xpack.profiling.stackFrames.subChart.avg', {
    defaultMessage: 'avg. {percentage}',
    values: {
      percentage: (0, _as_percentage.asPercentage)(percentage / 100)
    }
  }) : (0, _as_percentage.asPercentage)(percentage / 100))))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      position: 'relative'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_charts.Chart, {
    size: {
      height,
      width
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_charts.Tooltip, {
    showNullValues: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_charts.Settings, {
    showLegend: false,
    baseTheme: chartsBaseTheme,
    theme: chartsTheme,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_charts.AreaSeries, {
    id: category,
    name: category,
    data: data,
    xAccessor: 'Timestamp',
    yAccessors: ['Count'],
    xScaleType: _charts.ScaleType.Time,
    timeZone: timeZone,
    yScaleType: _charts.ScaleType.Linear,
    curve: _charts.CurveType.CURVE_STEP_AFTER,
    color: color,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  }), sample ? /*#__PURE__*/_react2.default.createElement(_charts.LineAnnotation, {
    id: "highlighted_sample",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: sample.Timestamp
    }],
    style: {
      line: {
        strokeWidth: 2,
        dash: [4, 4],
        opacity: 0.5
      }
    },
    marker: /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "dot",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 23
      }
    }),
    markerPosition: _charts.Position.Top,
    hideTooltips: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }) : null, showAxes ? /*#__PURE__*/_react2.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: (0, _charts.timeFormatter)('YYYY-MM-DD HH:mm:ss'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 13
    }
  }) : null, /*#__PURE__*/_react2.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    gridLine: {
      visible: true
    },
    tickFormat: d => showAxes ? Number(d).toFixed(0) : '',
    style: showAxes ? {} : {
      tickLine: {
        visible: false
      },
      tickLabel: {
        visible: false
      },
      axisTitle: {
        visible: false
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 11
    }
  })), !showAxes ? /*#__PURE__*/_react2.default.createElement("div", {
    style: {
      position: 'absolute',
      top: 0,
      left: 0,
      backgroundColor: `rgba(255, 255, 255, 0.75)`
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 11
    }
  }, sample ? (0, _as_number.asNumber)(sample.Count) : _i18n.i18n.translate('xpack.profiling.maxValue', {
    defaultMessage: 'Max: {max}',
    values: {
      max: (0, _as_number.asNumber)(Math.max(...data.map(value => {
        var _value$Count;
        return (_value$Count = value.Count) !== null && _value$Count !== void 0 ? _value$Count : 0;
      })))
    }
  })) : null), bottomElement);
}