"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePrompt = LicensePrompt;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _url = _interopRequireDefault(require("url"));
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/license_prompt/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KIBANA_LICENSE_MANAGEMENT_URL = '/app/management/stack/license_management';
function LicensePrompt() {
  const {
    core
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start;
  const manageLicenseURL = _url.default.format({
    pathname: core.http.basePath.prepend(KIBANA_LICENSE_MANAGEMENT_URL)
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "logoObservability",
    iconColor: "warning",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.profiling.invalidLicense.message', {
      defaultMessage: 'To access Universal Profiling, upgrade to an Enterprise subscription'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.profiling.invalidLicense.description', {
      defaultMessage: 'You must have an Enterprise subscription to use Universal Profiling features.'
    })),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "profilingLicensePromptUpgradeSubscriptionButton",
      href: manageLicenseURL,
      fill: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.profiling.invalidLicense.subscriptionManagementLink', {
      defaultMessage: 'Upgrade subscription'
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  });
}