"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCompareFrameAction = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _profilingUtils = require("@kbn/profiling-utils");
var _2 = require(".");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/differential_topn_functions_grid/get_compare_frame_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getCompareFrameAction = ({
  baseRows,
  comparisonRows,
  selectedFrame,
  onClick
}) => ({
  rowIndex,
  columnId,
  Component
}) => {
  const isComparison = (0, _2.isComparisonColumn)(columnId);
  const currentRow = isComparison ? comparisonRows[rowIndex] : baseRows[rowIndex];
  if (currentRow === undefined) {
    return null;
  }
  const currentFrameId = (0, _2.getFrameIdentification)(currentRow.frame);
  const isOpen = selectedFrame ? selectedFrame.currentFrameId === currentFrameId && selectedFrame.isComparison === isComparison : false;
  const compareRow = isComparison ? baseRows.find(item => (0, _2.getFrameIdentification)(item.frame) === currentFrameId) : comparisonRows.find(item => (0, _2.getFrameIdentification)(item.frame) === currentFrameId);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(Component, {
      onClick: () => {
        onClick({
          currentFrameId,
          isComparison
        });
      },
      iconType: "inspect",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.profiling.compareFrame.component.findLabel', {
      defaultMessage: 'Find corresponding frame'
    })),
    isOpen: isOpen,
    closePopover: () => {
      onClick(undefined);
    },
    anchorPosition: "upRight",
    css: (0, _react2.css)`
          .euiPopover__anchor {
            align-items: start;
            display: flex;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, compareRow ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, isComparison ? _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.baseLineFunction', {
    defaultMessage: 'Baseline function'
  }) : _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.comparisonLineFunction', {
    defaultMessage: 'Comparison function'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }, (0, _profilingUtils.getCalleeFunction)(compareRow.frame))), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: [compareRow],
    columns: [{
      field: 'rank',
      name: 'Rank'
    }, {
      field: 'samples',
      name: 'Samples',
      render: (_, value) => value.samples.toLocaleString()
    }, {
      field: 'selfCPUPerc',
      name: 'Self CPU',
      render: (_, value) => `${value.selfCPUPerc.toFixed(2)}%`
    }, {
      field: 'totalCPUPerc',
      name: 'Total CPU',
      render: (_, value) => `${value.totalCPUPerc.toFixed(2)}%`
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.noCorrespondingValueFound', {
    defaultMessage: 'No corresponding value found'
  })));
};
exports.getCompareFrameAction = getCompareFrameAction;