"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckSetup = CheckSetup;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _use_async = require("../hooks/use_async");
var _use_auto_aborted_http_client = require("../hooks/use_auto_aborted_http_client");
var _use_profiling_router = require("../hooks/use_profiling_router");
var _add_data_view = require("../views/add_data_view");
var _use_license_context = require("./contexts/license/use_license_context");
var _use_profiling_dependencies = require("./contexts/profiling_dependencies/use_profiling_dependencies");
var _license_prompt = require("./license_prompt");
var _profiling_app_page_template = require("./profiling_app_page_template");
var _use_profiling_setup_status = require("./contexts/profiling_setup_status/use_profiling_setup_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/check_setup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CheckSetup({
  children
}) {
  const {
    start: {
      core
    },
    services: {
      fetchHasSetup,
      postSetupResources
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const {
    setProfilingSetupStatus
  } = (0, _use_profiling_setup_status.useProfilingSetupStatus)();
  const license = (0, _use_license_context.useLicenseContext)();
  const router = (0, _use_profiling_router.useProfilingRouter)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    docLinks,
    notifications
  } = core;
  const [postSetupLoading, setPostSetupLoading] = (0, _react.useState)(false);
  const {
    status,
    data,
    error,
    refresh
  } = (0, _use_async.useAsync)(({
    http
  }) => {
    return fetchHasSetup({
      http
    });
  }, [fetchHasSetup]);
  if (status === _use_async.AsyncStatus.Settled) {
    setProfilingSetupStatus(data);
  }
  const http = (0, _use_auto_aborted_http_client.useAutoAbortedHttpClient)([]);
  if (!(license !== null && license !== void 0 && license.hasAtLeast('enterprise'))) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      hideSearchBar: true,
      tabs: [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }));
  }
  const displayLoadingScreen = status !== _use_async.AsyncStatus.Settled;
  if (displayLoadingScreen) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      hideSearchBar: true,
      tabs: [],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.profiling.noDataConfig.loading.loaderText', {
      defaultMessage: 'Loading data sources'
    })))));
  }
  const displaySetupScreen = status === _use_async.AsyncStatus.Settled && (data === null || data === void 0 ? void 0 : data.has_setup) !== true && (data === null || data === void 0 ? void 0 : data.pre_8_9_1_data) === false || !!error;
  if (displaySetupScreen) {
    return /*#__PURE__*/_react.default.createElement(_profiling_app_page_template.ProfilingAppPageTemplate, {
      tabs: [],
      noDataConfig: {
        action: {
          elasticAgent: {
            title: _i18n.i18n.translate('xpack.profiling.noDataConfig.pageTitle', {
              defaultMessage: 'Universal Profiling'
            }),
            description: _i18n.i18n.translate('xpack.profiling.noDataConfig.action.description', {
              defaultMessage: 'Universal Profiling provides fleet-wide, whole-system, continuous profiling with zero instrumentation. Understand what lines of code are consuming compute resources, at all times, and across your entire infrastructure.'
            }),
            buttonText: postSetupLoading ? _i18n.i18n.translate('xpack.profiling.noDataConfig.action.buttonLoadingLabel', {
              defaultMessage: 'Setting up Universal Profiling...'
            }) : _i18n.i18n.translate('xpack.profiling.noDataConfig.action.buttonLabel', {
              defaultMessage: 'Set up Universal Profiling'
            }),
            buttonIsDisabled: postSetupLoading && true || (data === null || data === void 0 ? void 0 : data.has_required_role) === false,
            disabledButtonTooltipText: (data === null || data === void 0 ? void 0 : data.has_required_role) === false ? _i18n.i18n.translate('xpack.profiling.noDataConfig.action.permissionsTooltip', {
              defaultMessage: 'You need superuser permissions to set up Universal Profiling.'
            }) : undefined,
            onClick: event => {
              event.preventDefault();
              setPostSetupLoading(true);
              postSetupResources({
                http
              }).then(() => refresh()).catch(err => {
                var _ref, _err$body$message, _err$body;
                const message = (_ref = (_err$body$message = err === null || err === void 0 ? void 0 : (_err$body = err.body) === null || _err$body === void 0 ? void 0 : _err$body.message) !== null && _err$body$message !== void 0 ? _err$body$message : err.message) !== null && _ref !== void 0 ? _ref : String(err);
                notifications.toasts.addError(err, {
                  title: _i18n.i18n.translate('xpack.profiling.checkSetup.setupFailureToastTitle', {
                    defaultMessage: 'Failed to complete setup'
                  }),
                  toastMessage: message
                });
              }).finally(() => {
                setPostSetupLoading(false);
              });
            },
            docsLink: `${docLinks.ELASTIC_WEBSITE_URL}guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-get-started.html`,
            'data-test-subj': 'profilingCheckSetupCard'
          }
        }
      },
      hideSearchBar: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
  }
  const displayUi =
  // Display UI if there's data or if the user is opening the add data instruction page.
  // does not use profiling router because that breaks as at this point the route might not have all required params
  (data === null || data === void 0 ? void 0 : data.has_data) === true && (data === null || data === void 0 ? void 0 : data.pre_8_9_1_data) === false || history.location.pathname === '/add-data-instructions' || history.location.pathname === '/delete_data_instructions';
  if (displayUi) {
    return children;
  }
  if ((data === null || data === void 0 ? void 0 : data.pre_8_9_1_data) === true) {
    // If the cluster still has data pre 8.9.1 version, redirect to deleting instructions
    router.push('/delete_data_instructions', {
      path: {},
      query: {}
    });
    return null;
  }
  if (status === _use_async.AsyncStatus.Settled && (data === null || data === void 0 ? void 0 : data.has_setup) === true && (data === null || data === void 0 ? void 0 : data.has_data) === false) {
    // when there's no data redirect the user to the add data instructions page
    router.push('/add-data-instructions', {
      path: {},
      query: {
        selectedTab: _add_data_view.AddDataTabs.Kubernetes
      }
    });
    return null;
  }
  throw new Error('Invalid state');
}