"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchStackTraces = searchStackTraces;
var _profilingUtils = require("@kbn/profiling-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function searchStackTraces({
  client,
  sampleSize,
  durationSeconds,
  co2PerKWH,
  datacenterPUE,
  pervCPUWattX86,
  pervCPUWattArm64,
  awsCostDiscountRate,
  costPervCPUPerHour,
  azureCostDiscountRate,
  showErrorFrames,
  indices,
  query,
  stacktraceIdsField
}) {
  const response = await client.profilingStacktraces({
    query,
    sampleSize,
    durationSeconds,
    co2PerKWH,
    datacenterPUE,
    pervCPUWattX86,
    pervCPUWattArm64,
    awsCostDiscountRate,
    costPervCPUPerHour,
    azureCostDiscountRate,
    indices,
    stacktraceIdsField
  });
  return (0, _profilingUtils.decodeStackTraceResponse)(response, showErrorFrames);
}