"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYMBOLIZER_PACKAGE_POLICY_NAME = exports.COLLECTOR_PACKAGE_POLICY_NAME = void 0;
exports.generateSecretToken = generateSecretToken;
exports.getCollectorPolicy = getCollectorPolicy;
exports.getSymbolizerPolicy = getSymbolizerPolicy;
exports.validateCollectorPackagePolicy = validateCollectorPackagePolicy;
exports.validateProfilingInApmPackagePolicy = validateProfilingInApmPackagePolicy;
exports.validateSymbolizerPackagePolicy = validateSymbolizerPackagePolicy;
var _common = require("@kbn/fleet-plugin/common");
var _get_apm_policy = require("./get_apm_policy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLLECTOR_PACKAGE_POLICY_NAME = exports.COLLECTOR_PACKAGE_POLICY_NAME = 'elastic-universal-profiling-collector';
const SYMBOLIZER_PACKAGE_POLICY_NAME = exports.SYMBOLIZER_PACKAGE_POLICY_NAME = 'elastic-universal-profiling-symbolizer';
async function getPackagePolicy({
  soClient,
  packagePolicyClient,
  packageName
}) {
  const packagePolicies = await packagePolicyClient.list(soClient, {
    kuery: `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.name:${packageName}`
  });
  return packagePolicies.items[0];
}
async function getCollectorPolicy({
  soClient,
  packagePolicyClient
}) {
  return getPackagePolicy({
    soClient,
    packagePolicyClient,
    packageName: COLLECTOR_PACKAGE_POLICY_NAME
  });
}
async function validateCollectorPackagePolicy({
  soClient,
  packagePolicyClient
}) {
  const collectorPolicy = await getCollectorPolicy({
    soClient,
    packagePolicyClient
  });
  return {
    policies: {
      collector: {
        installed: !!collectorPolicy
      }
    }
  };
}
function generateSecretToken() {
  let result = '';
  const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
  for (let i = 0; i < 16; i++) {
    const randomIndex = Math.floor(Math.random() * characters.length);
    result += characters.charAt(randomIndex);
  }
  return result;
}
async function getSymbolizerPolicy({
  soClient,
  packagePolicyClient
}) {
  return getPackagePolicy({
    soClient,
    packagePolicyClient,
    packageName: SYMBOLIZER_PACKAGE_POLICY_NAME
  });
}
async function validateSymbolizerPackagePolicy({
  soClient,
  packagePolicyClient
}) {
  const symbolizerPackagePolicy = await getSymbolizerPolicy({
    soClient,
    packagePolicyClient
  });
  return {
    policies: {
      symbolizer: {
        installed: !!symbolizerPackagePolicy
      }
    }
  };
}
async function validateProfilingInApmPackagePolicy({
  soClient,
  packagePolicyClient
}) {
  try {
    var _apmPolicy$inputs$0$c, _apmPolicy$inputs$0$c2;
    const apmPolicy = await (0, _get_apm_policy.getApmPolicy)({
      packagePolicyClient,
      soClient
    });
    return {
      policies: {
        apm: {
          profilingEnabled: !!(apmPolicy && apmPolicy !== null && apmPolicy !== void 0 && (_apmPolicy$inputs$0$c = apmPolicy.inputs[0].config) !== null && _apmPolicy$inputs$0$c !== void 0 && (_apmPolicy$inputs$0$c2 = _apmPolicy$inputs$0$c['apm-server'].value) !== null && _apmPolicy$inputs$0$c2 !== void 0 && _apmPolicy$inputs$0$c2.profiling)
        }
      }
    };
  } catch (e) {
    // In case apm integration is not available ignore the error and return as profiling is not enabled on the integration
    return {
      policies: {
        apm: {
          profilingEnabled: false
        }
      }
    };
  }
}