"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleUninstallAllTask = exports.registerUninstallAllTaskDefinition = exports.UNINSTALL_ALL_TASK_TYPE = exports.UNINSTALL_ALL_TASK_ID_MULTILINGUAL = exports.UNINSTALL_ALL_TASK_ID = void 0;
var _is_default_inference_endpoint = require("@kbn/product-doc-common/src/is_default_inference_endpoint");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UNINSTALL_ALL_TASK_TYPE = exports.UNINSTALL_ALL_TASK_TYPE = 'ProductDocBase:UninstallAll';
const UNINSTALL_ALL_TASK_ID = exports.UNINSTALL_ALL_TASK_ID = 'ProductDocBase:UninstallAll';
const UNINSTALL_ALL_TASK_ID_MULTILINGUAL = exports.UNINSTALL_ALL_TASK_ID_MULTILINGUAL = 'ProductDocBase:UninstallAllMultilingual';
const registerUninstallAllTaskDefinition = ({
  getServices,
  taskManager
}) => {
  taskManager.registerTaskDefinitions({
    [UNINSTALL_ALL_TASK_TYPE]: {
      title: `Uninstall all product documentation artifacts ${UNINSTALL_ALL_TASK_TYPE}`,
      timeout: '10m',
      maxAttempts: 3,
      createTaskRunner: context => {
        return {
          async run() {
            var _context$taskInstance, _context$taskInstance2;
            const {
              packageInstaller
            } = getServices();
            return packageInstaller.uninstallAll({
              inferenceId: (_context$taskInstance = context.taskInstance) === null || _context$taskInstance === void 0 ? void 0 : (_context$taskInstance2 = _context$taskInstance.params) === null || _context$taskInstance2 === void 0 ? void 0 : _context$taskInstance2.inferenceId
            });
          }
        };
      },
      stateSchemaByVersion: {}
    }
  });
};
exports.registerUninstallAllTaskDefinition = registerUninstallAllTaskDefinition;
const scheduleUninstallAllTask = async ({
  taskManager,
  logger,
  inferenceId
}) => {
  // To avoid conflicts between the default ELSER model and small E5 inference IDs running at the same time,
  // we use different task IDs for each inference ID.
  const taskId = (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? UNINSTALL_ALL_TASK_ID : UNINSTALL_ALL_TASK_ID_MULTILINGUAL;
  try {
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: UNINSTALL_ALL_TASK_TYPE,
      params: {
        inferenceId
      },
      state: {},
      scope: ['productDoc']
    });
    await taskManager.runSoon(taskId);
    logger.info(`Task ${taskId} scheduled to run soon`);
  } catch (e) {
    if (!(0, _utils.isTaskCurrentlyRunningError)(e)) {
      throw e;
    }
  }
  return taskId;
};
exports.scheduleUninstallAllTask = scheduleUninstallAllTask;