"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleInstallAllTask = exports.registerInstallAllTaskDefinition = exports.INSTALL_ALL_TASK_TYPE = exports.INSTALL_ALL_TASK_ID_MULTILINGUAL = exports.INSTALL_ALL_TASK_ID = void 0;
var _is_default_inference_endpoint = require("@kbn/product-doc-common/src/is_default_inference_endpoint");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_ALL_TASK_TYPE = exports.INSTALL_ALL_TASK_TYPE = 'ProductDocBase:InstallAll';
const INSTALL_ALL_TASK_ID = exports.INSTALL_ALL_TASK_ID = 'ProductDocBase:InstallAll';
const INSTALL_ALL_TASK_ID_MULTILINGUAL = exports.INSTALL_ALL_TASK_ID_MULTILINGUAL = 'ProductDocBase:InstallAllMultilingual';
const registerInstallAllTaskDefinition = ({
  getServices,
  taskManager
}) => {
  taskManager.registerTaskDefinitions({
    [INSTALL_ALL_TASK_TYPE]: {
      title: `Install all product documentation artifacts ${INSTALL_ALL_TASK_TYPE}`,
      timeout: '10m',
      maxAttempts: 3,
      createTaskRunner: context => {
        var _context$taskInstance, _context$taskInstance2;
        const inferenceId = (_context$taskInstance = context.taskInstance) === null || _context$taskInstance === void 0 ? void 0 : (_context$taskInstance2 = _context$taskInstance.params) === null || _context$taskInstance2 === void 0 ? void 0 : _context$taskInstance2.inferenceId;
        return {
          async run() {
            const {
              packageInstaller
            } = getServices();
            return packageInstaller.installAll({
              inferenceId
            });
          }
        };
      },
      stateSchemaByVersion: {}
    }
  });
};
exports.registerInstallAllTaskDefinition = registerInstallAllTaskDefinition;
const scheduleInstallAllTask = async ({
  taskManager,
  logger,
  inferenceId
}) => {
  const taskId = (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? INSTALL_ALL_TASK_ID : INSTALL_ALL_TASK_ID_MULTILINGUAL;
  try {
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: INSTALL_ALL_TASK_TYPE,
      params: {
        inferenceId
      },
      state: {},
      scope: ['productDoc']
    });
    await taskManager.runSoon(taskId);
    logger.info(`Task ${taskId} scheduled to run soon`);
  } catch (e) {
    if (!(0, _utils.isTaskCurrentlyRunningError)(e)) {
      throw e;
    }
  }
  return taskId;
};
exports.scheduleInstallAllTask = scheduleInstallAllTask;