"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.majorMinor = exports.latestVersion = void 0;
var _semver = _interopRequireDefault(require("semver"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @param availableVersions - List of available versions
 * @param kibanaVer - Kibana version
 * @returns The latest version from the list
 * If kibanaVer is provided, return the previous closest version available
 */
const latestVersion = (availableVersions, kibanaVer) => {
  var _latest;
  const kibanaSemver = kibanaVer ? _semver.default.coerce(kibanaVer) : undefined;
  let latest;
  for (const version of availableVersions) {
    const semver = _semver.default.coerce(version);
    if (!semver) continue;
    if (
    // If a Kibana version is provided,
    // narrow to only available versions prior to that Kibana version
    (!kibanaSemver || _semver.default.lte(semver, kibanaSemver)) && (
    // Else, grab the newer version from the list
    !latest || _semver.default.gt(semver, _semver.default.coerce(latest)))) {
      latest = version;
    }
  }
  return (_latest = latest) !== null && _latest !== void 0 ? _latest : availableVersions[0];
};
exports.latestVersion = latestVersion;
const majorMinor = version => {
  const parsed = _semver.default.coerce(version);
  if (!parsed) {
    throw new Error(`Not a valid semver version: [${version}]`);
  }
  return `${parsed.major}.${parsed.minor}`;
};
exports.majorMinor = majorMinor;