"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelTitle = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _customize_panel_action = require("../../panel_actions/customize_panel_action");
var _open_customize_panel = require("../../panel_actions/customize_panel_action/open_customize_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/presentation_panel/public/panel_component/panel_header/presentation_panel_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PresentationPanelTitle = ({
  api,
  headerId,
  viewMode,
  hideTitle,
  panelTitle,
  panelDescription
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onClick = (0, _react.useCallback)(() => {
    (0, _open_customize_panel.openCustomizePanelFlyout)({
      api: api,
      focusOnTitle: true
    });
  }, [api]);
  const panelTitleElement = (0, _react.useMemo)(() => {
    if (hideTitle) return null;
    const titleStyles = (0, _react2.css)`
      ${(0, _eui.euiTextTruncate)()};
      font-weight: ${euiTheme.font.weight.bold};

      .kbnGridPanel--active & {
        pointer-events: none; // prevent drag event from triggering onClick
      }
    `;
    if (viewMode !== 'edit' || !(0, _customize_panel_action.isApiCompatibleWithCustomizePanelAction)(api)) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "embeddablePanelTitle",
        css: titleStyles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 9
        }
      }, panelTitle);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      onClick: onClick,
      css: titleStyles,
      "aria-label": _i18n.i18n.translate('presentationPanel.header.titleAriaLabel', {
        defaultMessage: 'Click to edit title: {title}',
        values: {
          title: panelTitle
        }
      }),
      "data-test-subj": "embeddablePanelTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, panelTitle);
  }, [onClick, hideTitle, panelTitle, viewMode, api, euiTheme]);
  const describedPanelTitleElement = (0, _react.useMemo)(() => {
    if (hideTitle) return null;
    if (!panelDescription) {
      return panelTitleElement;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      title: panelTitle,
      content: panelDescription,
      delay: "regular",
      position: "top",
      anchorProps: {
        'data-test-subj': 'embeddablePanelTooltipAnchor'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "embeddablePanelTitleInner",
      className: "embPanel__titleInner",
      css: (0, _react2.css)`
            display: flex;
            flex-wrap: nowrap;
            column-gap: ${euiTheme.size.xs};
            align-items: center;
          `,
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, !hideTitle ? /*#__PURE__*/_react.default.createElement("h2", {
      // styles necessary for applying ellipsis and showing the info icon if description is present
      css: (0, _react2.css)`
                overflow: hidden;
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      id: headerId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 17
      }
    }, panelTitle ? _i18n.i18n.translate('presentationPanel.ariaLabel', {
      defaultMessage: 'Panel: {title}',
      values: {
        title: panelTitle
      }
    }) : _i18n.i18n.translate('presentationPanel.untitledPanelAriaLabel', {
      defaultMessage: 'Untitled panel'
    }))), panelTitleElement) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "subdued",
      "data-test-subj": "embeddablePanelTitleDescriptionIcon",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    })));
  }, [hideTitle, panelDescription, panelTitle, panelTitleElement, headerId, euiTheme.size.xs]);
  return describedPanelTitleElement;
};
exports.PresentationPanelTitle = PresentationPanelTitle;