"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowConfigPanelAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _rxjs = require("rxjs");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => {
  return (0, _presentationPublishing.hasReadOnlyCapabilities)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api);
};
class ShowConfigPanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_SHOW_CONFIG_PANEL);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_SHOW_CONFIG_PANEL);
    (0, _defineProperty2.default)(this, "order", 50);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _i18n.i18n.translate('presentationPanel.action.showConfigPanel.displayName', {
      defaultMessage: 'Show {value} configuration',
      values: {
        value: embeddable.getTypeDisplayName()
      }
    });
  }
  getCompatibilityChangesSubject({
    embeddable
  }) {
    var _getViewModeSubject;
    return (0, _presentationPublishing.apiCanAccessViewMode)(embeddable) ? (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(embeddable)) === null || _getViewModeSubject === void 0 ? void 0 : _getViewModeSubject.pipe((0, _rxjs.map)(() => undefined)) : undefined;
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable);
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'glasses';
  }

  /**
   * The compatible check is scoped to the read only capabilities
   * Note: it does not take into account write permissions
   */
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable) || (0, _presentationPublishing.getInheritedViewMode)(embeddable) !== 'view') {
      return false;
    }
    const {
      read: canRead,
      write: canWrite
    } = embeddable.isReadOnlyEnabled();
    return Boolean(
    // No option to view or edit the configuration is offered for users with write permission.
    canRead && !canWrite);
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    await embeddable.onShowConfig();
  }
}
exports.ShowConfigPanelAction = ShowConfigPanelAction;