"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLinks = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLinks = ({
  links
}) => Object.freeze({
  painlessExecuteAPI: links.apis.painlessExecute,
  painlessExecuteAPIContexts: links.apis.painlessExecuteAPIContexts,
  painlessAPIReference: links.scriptedFields.painlessApi,
  painlessWalkthrough: links.scriptedFields.painlessWalkthrough,
  painlessLangSpec: links.scriptedFields.painlessLangSpec,
  esQueryDSL: links.query.queryDsl,
  modulesScriptingPreferParams: links.elasticsearch.scriptParameters
});
exports.getLinks = getLinks;