"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MainControls = MainControls;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/painless_lab/public/application/components/main_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function MainControls({
  toggleRequestFlyout,
  isRequestFlyoutOpen,
  reset,
  links
}) {
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(false);
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "walkthrough",
    icon: "popout",
    href: links.painlessWalkthrough,
    target: "_blank",
    onClick: () => setIsHelpOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.painlessLab.walkthroughButtonLabel', {
    defaultMessage: 'Walkthrough'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "api",
    icon: "popout",
    href: links.painlessAPIReference,
    target: "_blank",
    onClick: () => setIsHelpOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.painlessLab.apiReferenceButtonLabel', {
    defaultMessage: 'API reference'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "languageSpec",
    icon: "popout",
    href: links.painlessLangSpec,
    target: "_blank",
    onClick: () => setIsHelpOpen(false),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.painlessLab.languageSpecButtonLabel', {
    defaultMessage: 'Language spec'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "reset",
    icon: "bolt",
    onClick: () => {
      reset();
      setIsHelpOpen(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.painlessLab.resetButtonLabel', {
    defaultMessage: 'Reset script'
  }))];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBottomBar, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "painlessLabHelpContextMenu",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "question",
      iconSide: "left",
      color: "text",
      onClick: () => setIsHelpOpen(!isHelpOpen),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.painlessLab.helpButtonLabel', {
      defaultMessage: 'Help'
    })),
    isOpen: isHelpOpen,
    closePopover: () => setIsHelpOpen(false),
    panelPaddingSize: "none",
    anchorPosition: "upLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    onClick: toggleRequestFlyout,
    "data-test-subj": "btnViewRequest",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, isRequestFlyoutOpen ? _i18n.i18n.translate('xpack.painlessLab.hideRequestButtonLabel', {
    defaultMessage: 'Hide API request'
  }) : _i18n.i18n.translate('xpack.painlessLab.showRequestButtonLabel', {
    defaultMessage: 'Show API request'
  })))));
}