"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortYamlFile = sortYamlFile;
var fs = _interopRequireWildcard(require("fs"));
var yaml = _interopRequireWildcard(require("js-yaml"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function sortAttributes(attributes) {
  if (!Array.isArray(attributes)) return [];

  // Sort attributes by name for deterministic ordering
  return attributes.sort((a, b) => {
    const nameA = a.name || '';
    const nameB = b.name || '';
    return nameA.localeCompare(nameB);
  });
}
function sortGroups(groups) {
  if (!Array.isArray(groups)) return [];
  return groups.map(group => {
    // Sort attributes within each group
    const sortedGroup = {
      ...group
    };
    if (sortedGroup.attributes) {
      sortedGroup.attributes = sortAttributes(sortedGroup.attributes);
    }
    return sortedGroup;
  }).sort((a, b) => {
    // Sort groups by ID for deterministic ordering
    const idA = a.id || '';
    const idB = b.id || '';
    return idA.localeCompare(idB);
  });
}
function sortYamlFile(inputFile, outputFile) {
  try {
    // Read and parse the YAML file
    const yamlContent = fs.readFileSync(inputFile, 'utf8');
    const data = yaml.load(yamlContent);
    if (!data || !data.groups) {
      throw new Error('Invalid YAML structure: missing "groups" property');
    }

    // Sort the groups and their attributes
    const sortedData = {
      ...data,
      groups: sortGroups(data.groups)
    };

    // Write the sorted YAML back to file
    const sortedYaml = yaml.dump(sortedData, {
      indent: 2,
      lineWidth: -1,
      // Disable line wrapping
      noRefs: true,
      // Disable anchors/references
      sortKeys: false // We handle sorting manually for better control
    });
    fs.writeFileSync(outputFile, sortedYaml, 'utf8');
  } catch (error) {
    const errorMessage = error instanceof Error ? error.message : String(error);
    throw new Error(`Failed to sort YAML file: ${errorMessage}`);
  }
}

// CLI function removed - sorting is now done automatically during generation