"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInternalSavedObjectsClient = exports.fetchOsqueryPackagePolicyIds = exports.convertShardsToObject = exports.convertShardsToArray = exports.convertECSMappingToObject = exports.convertECSMappingToArray = void 0;
var _server = require("@kbn/core/server");
var _lodash = require("lodash");
var _common = require("@kbn/fleet-plugin/common");
var _common2 = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertECSMappingToArray = ecsMapping => ecsMapping ? Object.entries(ecsMapping).map(item => ({
  key: item[0],
  value: item[1]
})) : undefined;
exports.convertECSMappingToArray = convertECSMappingToArray;
const convertECSMappingToObject = ecsMapping => (0, _lodash.reduce)(ecsMapping, (acc, value) => {
  acc[value.key] = value.value;
  return acc;
}, {});
exports.convertECSMappingToObject = convertECSMappingToObject;
const convertShardsToArray = shards => Object.entries(shards).map(item => ({
  key: item[0],
  value: item[1]
}));
exports.convertShardsToArray = convertShardsToArray;
const convertShardsToObject = shards => (0, _lodash.reduce)(shards, (acc, value) => {
  acc[value.key] = value.value;
  return acc;
}, {});
exports.convertShardsToObject = convertShardsToObject;
const getInternalSavedObjectsClient = async getStartServices => {
  const [coreStart] = await getStartServices();
  return new _server.SavedObjectsClient(coreStart.savedObjects.createInternalRepository());
};

/**
 * Fetches all package policy IDs for osquery_manager integration in the current space.
 * @param packagePolicyService - Fleet's package policy service
 * @param soClient - Saved objects client
 * @returns Array of package policy IDs
 */
exports.getInternalSavedObjectsClient = getInternalSavedObjectsClient;
const fetchOsqueryPackagePolicyIds = async (soClient, osqueryContext) => {
  const logger = osqueryContext.logFactory.get('fetchOsqueryPackagePolicyIds');
  const packagePolicyService = osqueryContext.service.getPackagePolicyService();
  if (!packagePolicyService) {
    throw new Error('Package policy service is not available');
  }
  logger.debug('Fetching osquery package policy IDs');
  const kuery = `${_common.PACKAGE_POLICY_SAVED_OBJECT_TYPE}.package.name:${_common2.OSQUERY_INTEGRATION_NAME}`;
  const idIterable = await packagePolicyService.fetchAllItemIds(soClient, {
    kuery
  });
  const ids = [];
  for await (const batch of idIterable) {
    ids.push(...batch);
  }
  logger.debug(`Fetched ${ids.length} osquery package policy IDs`);
  return ids;
};
exports.fetchOsqueryPackagePolicyIds = fetchOsqueryPackagePolicyIds;