"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAllResults = void 0;
var _reactQuery = require("@kbn/react-query");
var _i18n = require("@kbn/i18n");
var _kibana = require("../common/lib/kibana");
var _constants = require("../../common/constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAllResults = ({
  actionId,
  liveQueryActionId,
  activePage,
  startDate,
  limit,
  sort,
  kuery,
  isLive = false
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['allActionResults', {
    actionId,
    liveQueryActionId,
    activePage,
    limit,
    sort
  }], () => http.get(`/api/osquery/live_queries/${liveQueryActionId}/results/${actionId}`, {
    version: _constants.API_VERSIONS.public.v1,
    query: {
      page: activePage,
      pageSize: limit,
      ...(sort.length > 0 && {
        sort: sort[0].field,
        sortOrder: sort[0].direction
      }),
      ...(kuery && {
        kuery
      }),
      ...(startDate && {
        startDate
      })
    }
  }), {
    select: response => {
      var _response$data$total, _response$data$edges, _response$data$edges2;
      return {
        id: actionId,
        total: (_response$data$total = response.data.total) !== null && _response$data$total !== void 0 ? _response$data$total : 0,
        edges: (_response$data$edges = response.data.edges) !== null && _response$data$edges !== void 0 ? _response$data$edges : [],
        columns: Object.keys(((_response$data$edges2 = response.data.edges) === null || _response$data$edges2 === void 0 ? void 0 : _response$data$edges2.length) && response.data.edges[0].fields || {}).sort()
      };
    },
    keepPreviousData: true,
    refetchInterval: isLive ? 5000 : false,
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.live_query_results.fetchError', {
        defaultMessage: 'Error while fetching live query results'
      })
    })
  });
};
exports.useAllResults = useAllResults;