"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyIdComboBoxField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _agent_policies = require("../../agent_policies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/policy_id_combobox_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// Custom styling for drop down list items due to:
//  1) the max-width and overflow properties is added to prevent long agent policy
//     names/descriptions from overflowing the flex items
//  2) max-width is built from the grow property on the flex items because the value
//     changes based on if Fleet is enabled/setup or not

const StyledAgentPolicyColumn = (0, _styled.default)(_eui.EuiFlexItem)`
  max-width: ${({
  grow
}) => grow / 9 * 100};
  overflow: hidden;
`;
const PolicyIdComboBoxFieldComponent = ({
  euiFieldProps,
  options
}) => {
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'policy_ids',
    defaultValue: [],
    rules: {}
  });
  const selectedOptions = (0, _react.useMemo)(() => {
    if (agentPoliciesById) {
      return (0, _lodash.castArray)(value).map(policyId => {
        var _agentPoliciesById$po, _agentPoliciesById$po2;
        return {
          key: policyId,
          label: (_agentPoliciesById$po = (_agentPoliciesById$po2 = agentPoliciesById[policyId]) === null || _agentPoliciesById$po2 === void 0 ? void 0 : _agentPoliciesById$po2.name) !== null && _agentPoliciesById$po !== void 0 ? _agentPoliciesById$po : policyId
        };
      });
    }
    return [];
  }, [agentPoliciesById, value]);
  const handleChange = (0, _react.useCallback)(newOptions => {
    onChange(newOptions.map(option => option.key || option.label));
  }, [onChange]);
  const renderOption = (0, _react.useCallback)(option => {
    var _ref, _agentPoliciesById$op, _ref2, _ref3, _agentPoliciesById$op2;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(StyledAgentPolicyColumn, {
      grow: 2,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, (_ref = option.key && (agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : (_agentPoliciesById$op = agentPoliciesById[option.key]) === null || _agentPoliciesById$op === void 0 ? void 0 : _agentPoliciesById$op.name)) !== null && _ref !== void 0 ? _ref : option.label)), /*#__PURE__*/_react.default.createElement(StyledAgentPolicyColumn, {
      grow: 5,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      className: "eui-textTruncate",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, (_ref2 = option.key && (agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : agentPoliciesById[option.key].description)) !== null && _ref2 !== void 0 ? _ref2 : '')), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 2,
      className: "eui-textRight",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.createScheduledQuery.agentPolicyAgentsCountText",
      defaultMessage: "{count, plural, one {# agent} other {# agents}} enrolled"
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        count: (_ref3 = option.key && (agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : (_agentPoliciesById$op2 = agentPoliciesById[option.key]) === null || _agentPoliciesById$op2 === void 0 ? void 0 : _agentPoliciesById$op2.agents)) !== null && _ref3 !== void 0 ? _ref3 : 0
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }))));
  }, [agentPoliciesById]);
  const helpText = (0, _react.useMemo)(() => {
    if (!(value !== null && value !== void 0 && value.length) || !value[0].length || !agentPoliciesById) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.osquery.pack.form.agentPoliciesFieldHelpText",
        defaultMessage: "Queries in this pack are scheduled for agents in the selected policies.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 9
        }
      });
    }
    const agentCount = (0, _lodash.reduce)(value, (acc, policyId) => {
      var _agentPolicy$agents;
      const agentPolicy = agentPoliciesById && agentPoliciesById[policyId];
      return acc + ((_agentPolicy$agents = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.agents) !== null && _agentPolicy$agents !== void 0 ? _agentPolicy$agents : 0);
    }, 0);
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.createScheduledQuery.agentPolicyAgentsCountText",
      defaultMessage: "{count, plural, one {# agent} other {# agents}} enrolled"
      // eslint-disable-next-line react-perf/jsx-no-new-object-as-prop
      ,
      values: {
        count: agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    });
  }, [agentPoliciesById, value]);
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.osquery.pack.form.agentPoliciesFieldLabel', {
      defaultMessage: 'Scheduled agent policies (optional)'
    }),
    helpText: helpText,
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    isInvalid: hasError,
    selectedOptions: selectedOptions,
    fullWidth: true,
    "data-test-subj": "policyIdsComboBox",
    isClearable: true,
    options: options,
    renderOption: renderOption,
    onChange: handleChange
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  })));
};
const PolicyIdComboBoxField = exports.PolicyIdComboBoxField = /*#__PURE__*/_react.default.memo(PolicyIdComboBoxFieldComponent, _fastDeepEqual.default);