"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapperCss = exports.navCss = exports.containerCss = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const containerCss = ({
  euiTheme
}) => ({
  minHeight: `calc(100vh - ${parseFloat(euiTheme.size.xxxl) * 2}px)`,
  background: euiTheme.colors.emptyShade,
  display: 'flex',
  flexDirection: 'column'
});
exports.containerCss = containerCss;
const wrapperCss = exports.wrapperCss = {
  display: 'flex',
  flexDirection: 'column',
  flex: 1
};
const navCss = ({
  euiTheme
}) => ({
  background: euiTheme.colors.emptyShade,
  borderBottom: euiTheme.border.thin,
  padding: `${euiTheme.size.base} ${euiTheme.size.l} ${euiTheme.size.base} ${euiTheme.size.l}`,
  '.euiTabs': {
    paddingLeft: '3px',
    marginLeft: '-3px'
  }
});
exports.navCss = navCss;