"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentStatus = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _constants = require("../../common/constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
var _kibana = require("../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentStatus = ({
  policyId,
  skip
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['agentStatus', policyId], () => http.get(`/internal/osquery/fleet_wrapper/agent_status`, {
    version: _constants.API_VERSIONS.internal.v1,
    ...(policyId ? {
      query: {
        policyId
      }
    } : {})
  }), {
    enabled: !skip,
    select: response => response.results,
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.agent_status.fetchError', {
        defaultMessage: 'Error while fetching agent status'
      })
    })
  });
};
exports.useAgentStatus = useAgentStatus;