"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.chatSystemIndexPrefix = exports.chatSystemIndex = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Prefix of the chat system indices.
 *
 * The Kibana system user has the same permission on those indices than it has on Kibana system indices.
 */
const chatSystemIndexPrefix = exports.chatSystemIndexPrefix = '.chat-';

/**
 * Helper function to define chat system indices.
 */
const chatSystemIndex = suffix => {
  return `${chatSystemIndexPrefix}${suffix}`;
};
exports.chatSystemIndex = chatSystemIndex;