"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolsServiceStartMock = exports.createToolRegistryMock = exports.createToolProviderMock = exports.createMockedTool = exports.createMockedExecutableTool = exports.createMockedBuiltinTool = void 0;
var _zod = require("@kbn/zod");
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createToolProviderMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn()
  };
};
exports.createToolProviderMock = createToolProviderMock;
const createToolRegistryMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn(),
    create: jest.fn(),
    update: jest.fn(),
    delete: jest.fn(),
    execute: jest.fn()
  };
};
exports.createToolRegistryMock = createToolRegistryMock;
const createToolsServiceStartMock = () => {
  return {
    getToolTypeInfo: jest.fn(),
    getRegistry: jest.fn().mockImplementation(() => createToolRegistryMock())
  };
};
exports.createToolsServiceStartMock = createToolsServiceStartMock;
const createMockedBuiltinTool = (parts = {}) => {
  return {
    id: 'test-tool',
    type: _onechatCommon.ToolType.builtin,
    description: 'test description',
    schema: _zod.z.object({}),
    tags: ['tag-1', 'tag-2'],
    handler: jest.fn(parts.handler),
    ...parts
  };
};
exports.createMockedBuiltinTool = createMockedBuiltinTool;
const createMockedTool = (parts = {}) => {
  return {
    id: 'test-tool',
    type: _onechatCommon.ToolType.builtin,
    description: 'test description',
    configuration: {},
    readonly: false,
    tags: ['tag-1', 'tag-2'],
    getSchema: jest.fn(async () => _zod.z.object({})),
    getHandler: jest.fn(parts.getHandler),
    ...parts
  };
};
exports.createMockedTool = createMockedTool;
const createMockedExecutableTool = (parts = {}) => {
  return {
    id: 'test-tool',
    type: _onechatCommon.ToolType.builtin,
    description: 'test description',
    readonly: false,
    getSchema: () => _zod.z.object({}),
    configuration: {},
    tags: ['tag-1', 'tag-2'],
    ...parts,
    execute: jest.fn(parts.execute)
  };
};
exports.createMockedExecutableTool = createMockedExecutableTool;