"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isBuiltinToolRegistration = exports.convertTool = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _definitions = require("../tool_types/definitions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertTool = ({
  tool,
  definition,
  context
}) => {
  if (isBuiltinToolRegistration(tool)) {
    return {
      id: tool.id,
      type: _onechatCommon.ToolType.builtin,
      description: tool.description,
      tags: tool.tags,
      configuration: {},
      readonly: true,
      getSchema: () => tool.schema,
      getHandler: () => tool.handler
    };
  }
  if (!(0, _definitions.isBuiltinDefinition)(definition)) {
    const getDynamicProps = () => {
      return definition.getDynamicProps(tool.configuration, context);
    };
    return {
      id: tool.id,
      // static tools are surfaced as builtin
      type: _onechatCommon.ToolType.builtin,
      // static tools have their configuration obfuscated
      configuration: {},
      description: tool.description,
      tags: tool.tags,
      readonly: true,
      getSchema: async () => {
        const props = await getDynamicProps();
        return props.getSchema();
      },
      getHandler: async () => {
        const props = await getDynamicProps();
        return props.getHandler();
      },
      getLlmDescription: async args => {
        const props = await getDynamicProps();
        return props.getLlmDescription ? props.getLlmDescription(args) : tool.description;
      }
    };
  }

  // just making TS happy, this can never happen - type guard above are on different structure is all...
  throw new Error(`Non-builtin tool registration has a built-in definition: ${tool.id} /  ${tool.type}`);
};
exports.convertTool = convertTool;
const isBuiltinToolRegistration = tool => {
  return tool.type === _onechatCommon.ToolType.builtin;
};
exports.isBuiltinToolRegistration = isBuiltinToolRegistration;