"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createBuiltinToolRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBuiltinToolRegistry = () => {
  return new BuiltinToolRegistryImpl();
};
exports.createBuiltinToolRegistry = createBuiltinToolRegistry;
class BuiltinToolRegistryImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "tools", new Map());
  }
  register(tool) {
    if (this.tools.has(tool.id)) {
      throw new Error(`Tool with id ${tool.id} already registered`);
    }
    const errorMessage = (0, _onechatCommon.validateToolId)({
      toolId: tool.id,
      builtIn: true
    });
    if (errorMessage) {
      throw new Error(`Invalid tool id: "${tool.id}": ${errorMessage}`);
    }
    this.tools.set(tool.id, tool);
  }
  has(toolId) {
    return this.tools.has(toolId);
  }
  get(toolId) {
    return this.tools.get(toolId);
  }
  list() {
    return [...this.tools.values()];
  }
}