"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChatModel$ = void 0;
var _rxjs = require("rxjs");
var _telemetry = require("../../../telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getChatModel$ = ({
  connectorId,
  request,
  inference,
  span
}) => {
  return (0, _rxjs.defer)(async () => {
    span === null || span === void 0 ? void 0 : span.setAttribute('elastic.connector.id', connectorId);
    return inference.getChatModel({
      request,
      connectorId,
      chatModelOptions: {
        telemetryMetadata: _telemetry.MODEL_TELEMETRY_METADATA
      }
    });
  });
};
exports.getChatModel$ = getChatModel$;