"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConversationUpdatedEvent = exports.createConversationIdSetEvent = exports.createConversationCreatedEvent = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createConversationCreatedEvent = conversation => {
  return {
    type: _onechatCommon.ChatEventType.conversationCreated,
    data: {
      conversation_id: conversation.id,
      title: conversation.title
    }
  };
};
exports.createConversationCreatedEvent = createConversationCreatedEvent;
const createConversationUpdatedEvent = conversation => {
  return {
    type: _onechatCommon.ChatEventType.conversationUpdated,
    data: {
      conversation_id: conversation.id,
      title: conversation.title
    }
  };
};
exports.createConversationUpdatedEvent = createConversationUpdatedEvent;
const createConversationIdSetEvent = conversationId => {
  return {
    type: _onechatCommon.ChatEventType.conversationIdSet,
    data: {
      conversation_id: conversationId
    }
  };
};
exports.createConversationIdSetEvent = createConversationIdSetEvent;