"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roundToLangchain = exports.createToolCallMessages = exports.conversationToLangchainMessages = void 0;
var _messages = require("@langchain/core/messages");
var _onechatCommon = require("@kbn/onechat-common");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts a conversation to langchain format
 */
const conversationToLangchainMessages = ({
  previousRounds,
  nextInput,
  ignoreSteps = false
}) => {
  const messages = [];
  for (const round of previousRounds) {
    messages.push(...roundToLangchain(round, {
      ignoreSteps
    }));
  }
  messages.push(createUserMessage({
    content: nextInput.message
  }));
  return messages;
};
exports.conversationToLangchainMessages = conversationToLangchainMessages;
const roundToLangchain = (round, {
  ignoreSteps = false
} = {}) => {
  const messages = [];

  // user message
  messages.push(createUserMessage({
    content: round.input.message
  }));

  // steps
  if (!ignoreSteps) {
    for (const step of round.steps) {
      if ((0, _onechatCommon.isToolCallStep)(step)) {
        messages.push(...createToolCallMessages(step));
      }
    }
  }

  // assistant response
  messages.push(createAssistantMessage({
    content: round.response.message
  }));
  return messages;
};
exports.roundToLangchain = roundToLangchain;
const createUserMessage = ({
  content
}) => {
  return new _messages.HumanMessage({
    content
  });
};
const createAssistantMessage = ({
  content
}) => {
  return new _messages.AIMessage({
    content
  });
};
const createToolCallMessages = toolCall => {
  const toolName = (0, _langchain.sanitizeToolId)(toolCall.tool_id);
  const toolCallMessage = new _messages.AIMessage({
    content: '',
    tool_calls: [{
      id: toolCall.tool_call_id,
      name: toolName,
      args: toolCall.params,
      type: 'tool_call'
    }]
  });
  const toolResultMessage = new _messages.ToolMessage({
    tool_call_id: toolCall.tool_call_id,
    content: JSON.stringify({
      results: toolCall.results
    })
  });
  return [toolCallMessage, toolResultMessage];
};
exports.createToolCallMessages = createToolCallMessages;