"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAgentHandler = void 0;
var _run_agent = require("./run_agent");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create the handler function for the default onechat agent.
 */
const createAgentHandler = ({
  agent
}) => {
  return async ({
    agentParams: {
      nextInput,
      conversation = [],
      capabilities
    },
    runId,
    abortSignal
  }, context) => {
    const {
      round
    } = await (0, _run_agent.runAgent)({
      nextInput,
      conversation,
      capabilities,
      runId,
      abortSignal,
      agentId: agent.id,
      toolSelection: agent.configuration.tools,
      customInstructions: agent.configuration.instructions
    }, context);
    return {
      result: {
        round
      }
    };
  };
};
exports.createAgentHandler = createAgentHandler;