"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toInternalDefinition = exports.createBuiltinProviderFn = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createBuiltinProviderFn = ({
  registry
}) => ({
  request
}) => {
  return registryToProvider({
    registry,
    request
  });
};
exports.createBuiltinProviderFn = createBuiltinProviderFn;
const registryToProvider = ({
  registry,
  request
}) => {
  return {
    id: 'builtin',
    readonly: true,
    has: agentId => {
      return registry.has(agentId);
    },
    get: agentId => {
      const definition = registry.get(agentId);
      if (!definition) {
        throw (0, _onechatCommon.createAgentNotFoundError)({
          agentId
        });
      }
      return toInternalDefinition({
        definition
      });
    },
    list: opts => {
      const definitions = registry.list();
      return Promise.all(definitions.map(definition => toInternalDefinition({
        definition
      })));
    }
  };
};
const toInternalDefinition = async ({
  definition
}) => {
  return {
    ...definition,
    type: _onechatCommon.AgentType.chat,
    readonly: true
  };
};
exports.toInternalDefinition = toInternalDefinition;