"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAgentRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _onechatCommon = require("@kbn/onechat-common");
var _agents = require("@kbn/onechat-common/agents");
var _agent_source = require("./agent_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// for now it's the same

const createAgentRegistry = opts => {
  return new AgentRegistryImpl(opts);
};
exports.createAgentRegistry = createAgentRegistry;
class AgentRegistryImpl {
  constructor({
    persistedProvider,
    builtinProvider
  }) {
    (0, _defineProperty2.default)(this, "persistedProvider", void 0);
    (0, _defineProperty2.default)(this, "builtinProvider", void 0);
    this.persistedProvider = persistedProvider;
    this.builtinProvider = builtinProvider;
  }
  get orderedProviders() {
    return [this.builtinProvider, this.persistedProvider];
  }
  async has(agentId) {
    for (const provider of this.orderedProviders) {
      if (await provider.has(agentId)) {
        return true;
      }
    }
    return false;
  }
  async get(agentId) {
    for (const provider of this.orderedProviders) {
      if (await provider.has(agentId)) {
        return provider.get(agentId);
      }
    }
    throw (0, _onechatCommon.createAgentNotFoundError)({
      agentId
    });
  }
  async list(opts) {
    const allAgents = [];
    for (const provider of this.orderedProviders) {
      const providerAgents = await provider.list(opts);
      allAgents.push(...providerAgents);
    }
    return allAgents;
  }
  async create(createRequest) {
    const {
      id: agentId
    } = createRequest;
    const validationError = (0, _agents.validateAgentId)({
      agentId,
      builtIn: false
    });
    if (validationError) {
      throw (0, _onechatCommon.createBadRequestError)(`Invalid agent id: "${agentId}": ${validationError}`);
    }
    if (await this.has(agentId)) {
      throw (0, _onechatCommon.createBadRequestError)(`Agent with id ${agentId} already exists`);
    }
    return this.persistedProvider.create(createRequest);
  }
  async update(agentId, update) {
    for (const provider of this.orderedProviders) {
      if (await provider.has(agentId)) {
        if ((0, _agent_source.isReadonlyProvider)(provider)) {
          throw (0, _onechatCommon.createBadRequestError)(`Agent ${agentId} is read-only and can't be updated`);
        } else {
          return provider.update(agentId, update);
        }
      }
    }
    throw (0, _onechatCommon.createAgentNotFoundError)({
      agentId
    });
  }
  async delete({
    id: agentId
  }) {
    for (const provider of this.orderedProviders) {
      if (await provider.has(agentId)) {
        if ((0, _agent_source.isReadonlyProvider)(provider)) {
          throw (0, _onechatCommon.createBadRequestError)(`Agent ${agentId} is read-only and can't be deleted`);
        } else {
          return provider.delete(agentId);
        }
      }
    }
    throw (0, _onechatCommon.createAgentNotFoundError)({
      agentId
    });
  }
}