"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatToolDetailsPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _edit_tool = require("../components/tools/edit_tool");
var _view_tool = require("../components/tools/view_tool");
var _use_tools = require("../hooks/tools/use_tools");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _use_navigation = require("../hooks/use_navigation");
var _app_paths = require("../utils/app_paths");
var _i18n = require("../utils/i18n");
var _tools_provider = require("../context/tools_provider");
var _use_ui_privileges = require("../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1765195614889117819/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/pages/tool_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OnechatToolDetailsPage = () => {
  const {
    toolId
  } = (0, _reactRouterDom.useParams)();
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    tool,
    isLoading
  } = (0, _use_tools.useTool)({
    toolId
  });
  const {
    manageTools
  } = (0, _use_ui_privileges.useUiPrivileges)();
  (0, _use_breadcrumbs.useBreadcrumb)([{
    text: _i18n.labels.tools.title,
    path: _app_paths.appPaths.tools.list
  }, {
    text: toolId || '',
    path: _app_paths.appPaths.tools.details({
      toolId: toolId || ''
    })
  }]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    })));
  }
  if (!tool) {
    navigateToOnechatUrl(_app_paths.appPaths.tools.list);
    return;
  }
  return /*#__PURE__*/_react.default.createElement(_tools_provider.ToolsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, !tool.readonly && manageTools ? /*#__PURE__*/_react.default.createElement(_edit_tool.EditTool, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 53
    }
  }) : /*#__PURE__*/_react.default.createElement(_view_tool.ViewTool, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 68
    }
  }));
};
exports.OnechatToolDetailsPage = OnechatToolDetailsPage;